//-------------------------------------------------------------------------------------
// SID Monitor - Utility for Sudden Ionospheric Disturbances Monitoring Stations
// Copyright (C) 2005-2011 - Lionel Loudet
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
//-------------------------------------------------------------------------------------


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SID_monitor
{
    public partial class About : Form
    {
        public About()
        {
            InitializeComponent();
        }

        private void About_Load(object sender, EventArgs e)
        {
            this.labelLicence.Text = Application.ProductName + " comes with ABSOLUTELY NO WARRANTY.\nThis is free software, and you are welcome to redistribute it\nunder certain conditions.";
            this.labelApplicationVersion.Text = "Version: " + Application.ProductVersion;
            this.linkLabelMail.Links[0].LinkData = "mailto:lionel@loudet.org";
            this.linkLabelWebURL.Links[0].LinkData = "http://sidstation.loudet.org/SIDmonitor";
            this.linkLabelGPL.Links[0].LinkData = "http://www.gnu.org/copyleft/gpl.html";
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void linkLabel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            // Determine which link was clicked within the LinkLabel.
            LinkLabel currentLinkLabel = (LinkLabel)sender;
            currentLinkLabel.Links[currentLinkLabel.Links.IndexOf(e.Link)].Visited = true;

            // Display the appropriate link based on the value of the 
            // LinkData property of the Link object.
            string target = e.Link.LinkData as string;

            if ( null != target )
            {
                try
                {
                    if ( target.StartsWith("http://") )
                    {
                        System.Diagnostics.Process.Start("iexplore.exe", target);
                    }
                    else if ( target.StartsWith("mailto:") )
                    {
                        System.Diagnostics.Process.Start(target);
                    }
                }
                catch ( Exception ex )
                {
                   Program.MainForm.outputTextBoxDockablePanel.AddOutputTextErrorMessage("*** " + ex.ToString().Split('\n')[0] + "\n");
                }
            }
        }


    }
}